<?php
/**
 * Handles the integration with Custom Tables V1 of the Flexible Tickets project for features that are not
 * dependant on the ticket type.
 *
 * @since   5.8.0
 *
 * @package TEC\Tickets\Flexible_Tickets\Series_Passes\Series_Passes;
 */

namespace TEC\Tickets\Flexible_Tickets\Series_Passes;

use TEC\Common\Contracts\Provider\Controller;
use TEC\Events_Pro\Custom_Tables\V1\Series\Autogenerated_Series;
use TEC\Events_Pro\Custom_Tables\V1\Series\Post_Type as Series;

/**
 * Class CT1_Integration.
 *
 * @since   5.8.0
 *
 * @package TEC\Tickets\Flexible_Tickets\Series_Passes\Series_Passes;
 */
class CT1_Integration extends Controller {
	/**
	 * {@inheritDoc}
	 *
	 * @since 5.8.0
	 *
	 * @return void
	 */
	protected function do_register(): void {
		add_action( 'tribe_tickets_ticket_add', [ $this, 'remove_series_autogenerated_flag' ] );
	}

	/**
	 * {@inheritDoc}
	 *
	 * @since 5.8.0
	 *
	 * @return void
	 */
	public function unregister(): void {
		remove_action( 'tribe_tickets_ticket_add', [ $this, 'remove_series_autogenerated_flag' ] );
	}

	/**
	 * Removes the autogenerated flag from the Series when a ticket is added to it.
	 *
	 * @since 5.8.0
	 *
	 * @param int $post_id The ID of the post being saved.
	 *
	 * @return void Returns early if the post is not a Series.
	 */
	public function remove_series_autogenerated_flag( int $post_id ): void {
		if ( get_post_type( $post_id ) !== Series::POSTTYPE ) {
			return;
		}

		delete_post_meta( $post_id, Autogenerated_Series::FLAG_META_KEY );
		delete_post_meta( $post_id, Autogenerated_Series::CHECKSUM_META_KEY );
	}
}
